define("mod_quiz/reopen_attempt_ui",["exports","core/notification","core/ajax","core/str"],(function(_exports,_notification,_ajax,_str){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;
/**
   * This module has the code to make the Re-open attempt button work, if present.
   *
   * That is, it looks for buttons with HTML like
   * &lt;button type="button" data-action="reopen-attempt" data-attempt-id="227000" data-after-action-url="/mod/quiz/report.php">
   * and if that is clicked, it first shows an 'Are you sure' pop-up, and if they are sure,
   * the attempt is re-opened, and then the page reloads.
   *
   * @module    mod_quiz/reopen_attempt_ui
   * @copyright 2023 The Open University
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const reopenButtonClicked=async e=>{if(!(e.target instanceof HTMLElement&&e.target.matches('button[data-action="reopen-attempt"]')))return;e.preventDefault();const attemptId=e.target.dataset.attemptId;try{const messages=(0,_ajax.call)([{methodname:"mod_quiz_get_reopen_attempt_confirmation",args:{attemptid:attemptId}}]);await(0,_notification.saveCancelPromise)((0,_str.getString)("reopenattemptareyousuretitle","mod_quiz"),messages[0],(0,_str.getString)("reopenattempt","mod_quiz"),{triggerElement:e.target}),await(0,_ajax.call)([{methodname:"mod_quiz_reopen_attempt",args:{attemptid:attemptId}}])[0],window.location=M.cfg.wwwroot+e.target.dataset.afterActionUrl}catch(error){if("modal-save-cancel:cancel"===error.type)return;await(0,_notification.exception)(error)}};_exports.init=()=>{document.addEventListener("click",reopenButtonClicked)}}));

//# sourceMappingURL=reopen_attempt_ui.min.js.map